import matplotlib.pyplot as plt
import numpy as np


def dct(x, u, N):
    return np.cos((2 * np.pi * x * u) / N)


def dct2(x, u, N):
    return np.cos((np.pi * (x + 0.5) * u) / N)


fig = plt.figure()
ax1 = fig.add_axes([0.1, 0.5, 0.8, 0.4],
                   xticklabels=[], xlim=(0, 3), ylim=(-1.2, 1.2))
ax2 = fig.add_axes([0.1, 0.1, 0.8, 0.4],
                   xlim=(0, 3), ylim=(-1.2, 1.2))

x = np.linspace(0.0, 20, 2000)

ax1.plot(x, dct(x, 0, 3))
ax1.plot(x, dct(x, 1, 3))
ax1.plot(x, dct(x, 2, 3))
ax1.plot([1.0], [-0.5])
ax1.plot([1, 1], [-1.2, -0.5], color='black', linestyle='dotted')
ax1.plot([2, 2], [-1.2, -0.5], color='black', linestyle='dotted')
ax1.legend(['cos(2*pi*x*0/3)', 'cos(2*pi*x*1/3)', 'cos(2*pi*x*2/3)'],
           fontsize='small',
           loc=1)

ax2.plot(x, dct2(x, 0, 3))
ax2.plot(x, dct2(x, 1, 3))
ax2.plot(x, dct2(x, 2, 3))
ax2.legend(['cos(pi*(x+0.5)*0/3)', 'cos(pi*(x+0.5)*1/3)', 'cos(pi*(x+0.5)*2/3)'],
           fontsize='small',
           loc=7)

plt.savefig('dct_herleitung.svg')
plt.show()
