import matplotlib.pyplot as plt
import numpy as np


def f(t, a=1.0, w=1.0):
    return a * np.sin(t * 2 * np.pi * w)


def f2(t, a=1, w=1):
    return a * np.cos(t * 2 * np.pi * w)


fig = plt.figure()
ax1 = fig.add_axes([0.1, 0.5, 0.8, 0.4],
                   xticklabels=[], ylim=(-8, 8))
ax2 = fig.add_axes([0.1, 0.1, 0.8, 0.4],
                   ylim=(-8, 8))

x = np.linspace(0.0, 20, 200)
s1 = f(x, 1, 50)
s2 = f(x, 2, 100)
s3 = f2(x, 3, 10)

y = s1 + s2 + s3

# plt.plot(x, y)
# plt.plot(x, s1)
# plt.plot(x, s2)
# plt.plot(x, s3)
ax1.plot(x, y)
ax2.plot(x, s1)
ax2.plot(x, s2)
ax2.plot(x, s3)
plt.savefig('periodische_funktionen.svg')
plt.show()
