from __future__ import annotations

from random import randint, random

from sema.teil2.HammingCode import HammingCode


def encode(s: str) -> list[list[int]]:
    HC = HammingCode(4)
    return [[int(e) for e in HC.encode([int(bit) for bit in byte]).elements.tolist()] for byte in
            [format(ord(c), '011b') for c in s]]


def decode(bytes: list[list[int]]) -> str:
    HC = HammingCode(4)
    return ''.join([chr(int(''.join(bytes), 2)) for bytes in ([str(bit) for bit in HC.decode(byte)] for byte in bytes)])


def channel(bytes: list[list[int]], errorsPerByte: int = 0, errorProbability: float = 1) -> list[list[int]]:
    for byte in bytes:
        for i in range(errorsPerByte):
            pos = randint(0, 14)  # With HC(11,4) encoded blocks, have 15 bits
            byte[pos] = (byte[pos] + 1) % 2 if errorProbability > random() else byte[pos]

    return bytes


def transmit(message: str, errorsPerByte: int = 0, errorProbability: float = 1) -> str:
    return decode(channel(encode(message), errorsPerByte, errorProbability))
