import linalg.linmap.maps as maps
from linalg.Matrix import Matrix

import unittest


class MapsModule(unittest.TestCase):
    def test_hScale_returns_horizontal_scaling_matrix(self):
        matrix = maps.hScale(2)
        self.assertTrue(type(matrix) is Matrix)
        self.assertTrue(matrix == [[2, 0], [0, 1]])

    def test_vScale_returns_vertical_scaling_matrix(self):
        matrix = maps.vScale(2)
        self.assertTrue(type(matrix) is Matrix)
        self.assertTrue(matrix == [[1, 0], [0, 2]])

    def test_scale_returns_scaling_matrix(self):
        matrix = maps.scale(-1, 2)
        self.assertTrue(type(matrix) is Matrix)
        self.assertTrue(matrix == [[-1, 0], [0, 2]])

    def test_zoom_returns_zooming_matrix(self):
        matrix = maps.zoom(10)
        self.assertTrue(type(matrix) is Matrix)
        self.assertTrue(matrix == [[10, 0], [0, 10]])

    def test_identity_returns_id_matrix(self):
        identity = maps.identity(2)
        identity3d = maps.identity(3)
        self.assertTrue(type(identity) is Matrix)
        self.assertTrue(identity == [[1, 0], [0, 1]])
        self.assertTrue(identity3d == [[1, 0, 0], [0, 1, 0], [0, 0, 1]])
