from linalg.plot.CoordinateSystem import CoordinateSystem
from linalg.Vector import Vector
from linalg.Matrix import Matrix


def projectionMatrix2d(direction, h):
    v, w = direction[0], direction[1]
    return Matrix([w, -v, v * h],
                  [0, 0, h * w],
                  [0, 0, w])


def drawPoint(c, p, direction, name):
    c.drawPoint(p, marker='o', markersize=10, fillstyle='none', zorder=3)
    c.drawDirectionArrow(p, p + direction, color='grey', width=0.05, zorder=2)
    c.drawInfiniteLine(p, p + direction, color='grey', linestyle='dotted', zorder=1)
    c.plot.text(*(p + [.2, 0]), "$" + name + "$", size=12)
    c.plot.text(*(p + direction * 0.5), '$\\vec{v}$', color='grey', size=12)


def drawProjectedPoint(c, p, M, name):
    p_prime = (M * p.homog()).deHomog()
    c.drawPoint(p_prime, marker='o', markersize=10, color='blue', fillstyle='none', zorder=3)
    c.plot.text(*(p_prime + [.2, 0]), "$" + name + "$", size=12)


direction = Vector(1, -1.5)
height = 2
M = projectionMatrix2d(direction, height)
p1 = Vector(4, 6)
p2 = Vector(-1, 5)

c = CoordinateSystem(xRange=(-2, 8), yRange=(-2, 8))
c.drawInfiniteLine([0, height], [1, height], color='red')
drawPoint(c, p1, direction, 'p_1')
drawPoint(c, p2, direction, 'p_2')
drawProjectedPoint(c, p1, M, 'p_1\'')
drawProjectedPoint(c, p2, M, 'p_2\'')

# Workaround (draw axis arrows)
c.drawPositionArrow(8, 0, color='#4C4C4C', width=0.01)
c.plot.text(*[7.5, -.5], "$x$", color='#4C4C4C', size=12)
c.drawPositionArrow(0, 8, color='#4C4C4C', width=0.01)
c.plot.text(*[-.5, 7.5], "$y$", color='#4C4C4C', size=12)

c.save('pp2d.svg', bbox_inches='tight')
c.show()
