import matplotlib.pyplot as plt
import numpy as np
from scipy.fft import fft, fftfreq


def f(t, a=1.0, w=1.0):
    return a * np.sin(t * 2 * np.pi * w)


def f2(t, a=1, w=1):
    return a * np.cos(t * 2 * np.pi * w)


# Number of sample points
N = 600

# sample spacing
T = 1.0 / 800.0


x = np.linspace(0.0, N * T, N, endpoint=False)
s1 = f(x, 1, 50)
s2 = f(x, 2, 100)
s3 = f2(x, 3, 10)

y = s1 + s2 + s3
yf = fft(y)
xf = fftfreq(N, T)[:N // 2]

plt.plot(xf, 2.0 / N * np.abs(yf[0:N // 2]))

plt.savefig('fft.svg')
plt.show()
